<?php
/**
 * CoeusSEO ZIP Factory - Final Build
 * Logic: Tokenized Filename + Slate/Blue Theme
 */

// 1. Inputs
$domain = filter_input(INPUT_GET, 'domain', FILTER_SANITIZE_URL) ?: 'your-site.com';
$cleanDomain = str_replace(['http://', 'https://', 'www.'], '', $domain);
// Generate a clean 6-char key (No ambiguous characters)
$accessKey = substr(str_shuffle("23456789ABCDEFGHJKLMNPQRSTUVWXYZ"), 0, 6);

// 2. Paths
$tmpFolder = __DIR__ . '/tmp';
if (!is_dir($tmpFolder)) mkdir($tmpFolder, 0755, true);
$tmpZipFile = $tmpFolder . '/Coeus_SSL_Kit_' . $accessKey . '.zip';

$zip = new ZipArchive();
if ($zip->open($tmpZipFile, ZipArchive::CREATE) !== TRUE) {
    die("Server Error: Folder permissions prevent ZIP creation.");
}

// 3. Template Transformation
$readme = file_get_contents(__DIR__ . '/templates/README_TEMPLATE.html');
$readme = str_replace(['{{DOMAIN}}', '{{ACCESS_KEY}}'], [$cleanDomain, $accessKey], $readme);

$installer = file_get_contents(__DIR__ . '/templates/INSTALLER_TEMPLATE.php');
$installer = str_replace(['{{DOMAIN}}', '{{ACCESS_KEY}}'], [$cleanDomain, $accessKey], $installer);

// 4. Final ZIP Assembly
$zip->addFromString('READ_ME_FIRST.html', $readme);
$zip->addFromString($accessKey . '.php', $installer); // Secure tokenized filename
$zip->close();

// 5. Stream to User
header('Content-Type: application/zip');
header('Content-Disposition: attachment; filename="CoeusSEO_SSL_Kit_' . $cleanDomain . '.zip"');
header('Content-Length: ' . filesize($tmpZipFile));
readfile($tmpZipFile);

// 6. Cleanup
unlink($tmpZipFile);
exit;