<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>SSL Kit Generator</title>
    <style>
        :root {
            --coeus-blue: #1F2F99;
            --sky-blue: #38bdf8;
            --slate-900: #0f172a;
            --slate-800: #1e293b;
            --slate-400: #94a3b8;
        }

        body {
            margin: 0;
            padding: 0;
            display: flex;
            align-items: center;
            justify-content: center;
            min-height: 100vh;
            background-color: var(--slate-900);
            font-family: 'Segoe UI', Roboto, Helvetica, Arial, sans-serif;
            color: white;
        }

        .container {
            width: 100%;
            max-width: 450px;
            padding: 20px;
            text-align: center;
        }

        .card {
            background-color: var(--slate-800);
            padding: 40px;
            border-radius: 16px;
            border: 1px solid #334155;
            box-shadow: 0 25px 50px -12px rgba(0, 0, 0, 0.5);
        }

        h1 {
            font-size: 1.5rem;
            margin-bottom: 10px;
            letter-spacing: 1px;
        }

        p {
            color: var(--slate-400);
            font-size: 0.9rem;
            margin-bottom: 30px;
        }

        .input-group {
            margin-bottom: 20px;
            text-align: left;
        }

        label {
            display: block;
            margin-bottom: 8px;
            font-size: 0.8rem;
            font-weight: bold;
            color: var(--sky-blue);
            text-transform: uppercase;
        }

        input[type="text"] {
            width: 100%;
            padding: 14px;
            border-radius: 8px;
            border: 1px solid #334155;
            background: var(--slate-900);
            color: white;
            font-size: 1rem;
            box-sizing: border-box;
            outline: none;
            transition: border-color 0.2s;
        }

        input[type="text"]:focus {
            border-color: var(--sky-blue);
        }

        .btn {
            width: 100%;
            background-color: var(--coeus-blue);
            color: white;
            padding: 16px;
            border: none;
            border-radius: 8px;
            font-size: 1rem;
            font-weight: bold;
            cursor: pointer;
            transition: all 0.2s;
            text-decoration: none;
            display: block;
        }

        .btn:hover {
            background-color: #2a3ebf;
            transform: translateY(-1px);
            box-shadow: 0 4px 12px rgba(31, 47, 153, 0.4);
        }

        .footer {
            margin-top: 30px;
            font-size: 0.75rem;
            color: var(--slate-400);
        }

        .footer a {
            color: var(--sky-blue);
            text-decoration: none;
        }
    </style>
</head>
<body>

    <div class="container">
        <div class="card">
            <h1>SSL Kit Builder</h1>
            <p>Generate a custom, self-destructing installer for your domain.</p>

            <form action="download.php" method="GET">
                <div class="input-group">
                    <label for="domain">Domain Name</label>
                    <input type="text" id="domain" name="domain" placeholder="example.com" required autocomplete="off">
                </div>
                
                <button type="submit" class="btn">Download Installer Kit</button>
            </form>

            <div class="footer">
                Built to be open. <br>
                Modified & Distributed by <a href="https://coeusseo.com">CoeusSEO</a>
            </div>
        </div>
        
        <div style="margin-top: 20px; font-size: 0.7rem; color: #475569;">
            "Build something cool."
        </div>
    </div>

</body>
</html>