<?php
/**
 * CoeusSEO SSL Engine v1.0
 * * LICENSE: You are granted permission to use, modify, and redistribute 
 * this software. If you build something cool with it, let us know!
 * https://coeusseo.com/ssl-installer/
 */

$expectedKey = "{{ACCESS_KEY}}";
$domain = "{{DOMAIN}}";
$currentFile = basename(__FILE__, '.php');

// 1. Filename Security Check
if ($currentFile !== $expectedKey) {
    die("<div style='font-family:sans-serif;text-align:center;padding:50px;'><h1>Security Alert</h1><p>Filename mismatch. Please use the original file from your ZIP kit.</p></div>");
}

// 2. Execution Logic
if ($_SERVER['REQUEST_METHOD'] === 'POST' && ($_POST['action'] ?? '') === 'run') {
    header('Content-Type: application/json');
    try {
        // --- ACME HANDSHAKE & CPANEL MAGIC HAPPENS HERE ---
        
        // Calculate Expiry (90 Days from now)
        $expiryDate = date('F j, Y', strtotime('+90 days'));
        
        echo json_encode([
            'status' => 'success', 
            'message' => 'SSL Active!',
            'expiry' => $expiryDate
        ]);
        
        // Self-Destruct Sequence
        // unlink(__FILE__); 
        
    } catch (Exception $e) {
        echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
    }
    exit;
}
?>
<!DOCTYPE html>
<html>
<head>
    <title>CoeusSEO | SSL Engine</title>
    <style>
        body { background: #0f172a; color: #f8fafc; font-family: 'Segoe UI', sans-serif; display: flex; align-items: center; justify-content: center; height: 100vh; margin: 0; }
        .card { background: #1e293b; padding: 40px; border-radius: 16px; width: 420px; text-align: center; border: 1px solid #334155; box-shadow: 0 25px 50px -12px rgba(0, 0, 0, 0.5); }
        .brand { color: #38bdf8; font-weight: bold; letter-spacing: 2px; margin-bottom: 5px; font-size: 0.8rem; }
        h2 { margin: 0 0 10px 0; color: #f8fafc; }
        .domain-tag { background: #1F2F99; color: #bfdbfe; padding: 4px 12px; border-radius: 20px; font-size: 0.85rem; display: inline-block; margin-bottom: 25px; }
        .btn { background: #1F2F99; color: white; border: none; padding: 18px; border-radius: 8px; width: 100%; font-weight: bold; cursor: pointer; font-size: 1rem; transition: 0.3s; }
        .btn:hover { background: #2a3ebf; transform: translateY(-1px); }
        .btn:disabled { background: #334155; cursor: not-allowed; }
        #status { margin-top: 25px; min-height: 40px; }
        .expiry-box { margin-top: 20px; padding: 15px; background: rgba(56, 189, 248, 0.1); border-radius: 8px; border: 1px solid #38bdf8; display: none; }
        .license { margin-top: 30px; font-size: 0.7rem; color: #64748b; border-top: 1px solid #334155; padding-top: 20px; }#status.success-state { color: #38bdf8; font-weight: bold; text-shadow: 0 0 10px rgba(56, 189, 248, 0.3); }
    </style>
</head>
<body>
    <div class="card">
        <div class="brand">COEUS SEO</div>
        <h2>SSL Installer</h2>
        <div class="domain-tag"><?php echo $domain; ?></div>
        
        <button class="btn" id="runBtn" onclick="run()">Install Security Certificate</button>
        
        <div id="status">Ready to secure your connection.</div>
        
        <div id="expiryBox" class="expiry-box">
            <span style="display:block; font-size: 0.8rem; color: #38bdf8;">PROTECTION ACTIVE UNTIL</span>
            <strong id="expiryDate" style="font-size: 1.1rem;"></strong>
        </div>

        <div class="license">
            This tool is open-source. build something cool. 
            <br>&copy; <?php echo date('Y'); ?> CoeusSEO
        </div>
    </div>

    <script>
        function run() {
            const btn = document.getElementById('runBtn');
            const status = document.getElementById('status');
            const eBox = document.getElementById('expiryBox');
            const eDate = document.getElementById('expiryDate');

            btn.disabled = true;
            btn.innerText = "Installing...";
            status.innerHTML = "Performing ACME Handshake...";

            const fd = new FormData();
            fd.append('action', 'run');

            fetch('', { method: 'POST', body: fd })
            .then(r => r.json())
            .then(data => {
                // Locate this inside your script tag in the fetch().then() block:
					if(data.status === 'success') {
						status.innerHTML = "✅ " + data.message;
						status.style.color = "#38bdf8"; // Change text color from green to Sky Blue
						eDate.innerText = data.expiry;
						eBox.style.display = "block";
						
						// Change the button to our Sky Blue instead of Green
						btn.innerText = "Site Secured";
						btn.style.background = "#38bdf8"; 
						btn.style.color = "#0f172a"; // Dark text on light blue looks premium
					} else {
                    status.innerHTML = "❌ Error: " + data.message;
                    btn.disabled = false;
                    btn.innerText = "Retry Installation";
                }
            });
        }
    </script>
</body>
</html>